/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.mod.illager_more.entities.royal_guard;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;

public interface RoyalGuardTypesEntity {
    public AbstractIllager getLeader();

    public boolean canBeTeamLeader();

    public int getShieldCooldownTime();

    public byte getLeaderAttackType();

    public byte getAttackType();

    public void setShieldCooldownTime(int var1);

    public void disableShield(boolean var1);

    default public boolean canUseShield() {
        return false;
    }

    default public boolean isBulky() {
        return false;
    }

    default public void shieldHurt(float amount, LivingEntity livingEntity) {
        if (livingEntity.m_21211_().m_41720_() instanceof ShieldItem && amount >= 3.0f) {
            int i = 1 + Mth.m_14143_((float)amount);
            InteractionHand hand = livingEntity.m_7655_();
            livingEntity.m_21211_().m_41622_(i, livingEntity, entity -> entity.m_21190_(hand));
            if (livingEntity.m_21211_().m_41619_()) {
                if (hand == InteractionHand.MAIN_HAND) {
                    livingEntity.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                } else {
                    livingEntity.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                livingEntity.m_5810_();
                livingEntity.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + livingEntity.f_19853_.f_46441_.m_188501_() * 0.4f);
            }
        }
    }

    default public void breakShield(LivingEntity livingEntity, LivingEntity from) {
        this.disableShield(from.m_21205_().canDisableShield(livingEntity.m_21211_(), livingEntity, from));
    }

    default public void hurtSound(DamageSource damageSource, LivingEntity livingEntity, SoundEvent soundEvents) {
        if (!(livingEntity instanceof RoyalGuardTypesEntity)) {
            return;
        }
        RoyalGuardTypesEntity royalGuardTypesEntity = (RoyalGuardTypesEntity)livingEntity;
        if (royalGuardTypesEntity.getShieldCooldownTime() == 100) {
            livingEntity.m_5496_(SoundEvents.f_12347_, 1.0f, 0.8f + livingEntity.f_19853_.f_46441_.m_188501_() * 0.4f);
        } else if (livingEntity.m_21254_()) {
            livingEntity.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + livingEntity.f_19853_.f_46441_.m_188501_() * 0.4f);
        } else {
            livingEntity.m_5496_(soundEvents, 1.0f, livingEntity.m_6100_());
        }
    }
}

